#!/usr/bin/env Rscript
library(Rmpi)
library('parallel')
n.cores <- mpi.universe.size()
cl <- makeCluster(n.cores, type='MPI')
result <- parLapply(cl, 1:n.cores,
           function (i) {system2('hostname', stdout=TRUE)})
summary(factor(unlist(result)))
stopCluster(cl)
mpi.quit() 
