#!/usr/bin/env Rscript
 
hello.world <- function(i) {
   sprintf('Hello from loop iteration %d running on rank %d on node %s',
       i, mpi.comm.rank(), Sys.info()[c("nodename")]);
}
 
library(foreach)
library(doMPI)
cl <- startMPIcluster(4,includemaster=TRUE)
 
registerDoMPI(cl)
 
output.lines <- foreach(i = (1:10)) %dopar% {
   hello.world(i)
}

cat(unlist(output.lines), sep='\n')
 
closeCluster(cl)
mpi.quit()
